unit VCDLG32; {Feb14/97 9:30am}{Aug 12/99 BRM}

interface

uses WinTypes, VCType32;

function VCLoadVCDLG32 : boolean;
procedure VCFreeVCDLG32;
procedure VCAddPlotter(var iError: smallint; szPlotterName: PChar); stdcall;
procedure VCAddPlotterLanguageName(var iError: smallint; szLanguageName: PChar); stdcall;
procedure VCAddPlotterPageSize(var iError: smallint; var pPageSize: Point2D); stdcall;
procedure VCAddPlotterPenMapName(var iError: smallint; szPenMapName: PChar); stdcall;
procedure VCApplyPlotterLanguageDefaults(var iError: smallint); stdcall;
procedure VCApplyPlotterPenMapDefaults(var iError: smallint); stdcall;
procedure VCBirdsEye(var iError: smallint; iDisplayMode: smallint); stdcall;
procedure VCChangeRefFrameNameDlg(var iError: smallint); stdcall;
procedure VCChangeRibalog; stdcall;
procedure VCCloseRibalog(var iError: smallint); stdcall;
procedure VCDBLineSettingsRibalog; stdcall;
procedure VCDeInitPrintMode(var iError: smallint); stdcall;
procedure VCDimArrowRibalog; stdcall;
procedure VCDimDisplayRibalog; stdcall;
procedure VCDimExtRibalog; stdcall;
procedure VCDimLeaderRibalog; stdcall;
procedure VCDimLineRibalog; stdcall;
procedure VCDimStringsRibalog; stdcall;
procedure VCDimTextRibalog; stdcall;
procedure VCDimToleranceRibalog; stdcall;
procedure VCFilletRadiusRibalog; stdcall;
procedure VCFilterRibalog; stdcall;
function VCGetCurrentPrinter(var iError: smallint; szPrinter: PChar):Smallint; stdcall;
function VCGetDefaultPrinter(var iError: smallint; szDefaultPrinter: PChar):Smallint; stdcall;
function VCGetDialogFromId (var id: smallint):Longint;stdcall;
procedure VCGetPlotSettings(var iError: smallint; var pSettings: PlotStruct); stdcall;
function VCGetPlotterCount(var iError: smallint):Smallint; stdcall;
function VCGetPlotterCurrentLanguageName(var iError: smallint; szLanguageName: PChar):Smallint; stdcall;
procedure VCGetPlotterCurrentPageSize(var iError: smallint; var iIndex: smallint; var pPaperSize: Point2D); stdcall;
function VCGetPlotterCurrentPenMapName(var iError: smallint; szPenMapName: PChar):Smallint; stdcall;
function VCGetPlotterDeInitString(var iError: smallint; sz: PChar):Smallint; stdcall;
function VCGetPlotterDelimiter(var iError: smallint; sz: PChar):Smallint; stdcall;
function VCGetPlotterInitString(var iError: smallint; sz: PChar):Smallint; stdcall;
function VCGetPlotterLanguageCount(var iError: smallint):Smallint; stdcall;
function VCGetPlotterLanguageName(var iError: smallint; iIndex: smallint; szLanguageName: PChar):Smallint; stdcall;
procedure VCGetPlotterPageSize(var iError: smallint; iIndex: smallint; var pPaperSize: Point2D); stdcall;
function VCGetPlotterPageSizeCount(var iError: smallint):Smallint; stdcall;
function VCGetPlotterPenChangeString(var iError: smallint; sz: PChar):Smallint; stdcall;
function VCGetPlotterPenDownString(var iError: smallint; sz: PChar):Smallint; stdcall;
function VCGetPlotterPenDrawString(var iError: smallint; sz: PChar):Smallint; stdcall;
function VCGetPlotterPenMapCount(var iError: smallint):Smallint; stdcall;
function VCGetPlotterPenMapName(var iError: smallint; iIndex: smallint; szPenMapName: PChar):Smallint; stdcall;
procedure VCGetPlotterPenMapping(var iError: smallint; iColor: smallint; var iPen: smallint; var dWidth: Double; var iSpeed: smallint); stdcall;
function VCGetPlotterPenMoveString(var iError: smallint; sz: PChar):Smallint; stdcall;
function VCGetPlotterPenSpeedString(var iError: smallint; sz: PChar):Smallint; stdcall;
function VCGetPlotterPenUpString(var iError: smallint; sz: PChar):Smallint; stdcall;
procedure VCGetPrintSettings(var iError: smallint; var pSettings: PrintStruct); stdcall;
function VCGetPrinterName(var iError: smallint; iIndex: smallint; szPrinter: PChar):Smallint; stdcall;
function VCGetPrinterNameCount(var iError: smallint):Smallint; stdcall;
procedure VCGetRibalogSize(var iError: smallint; var ipOrg: iPoint2D; var ipSize: iPoint2D); stdcall;
function VCGetSpecificPrinter(var iError: smallint; szSpecificPrinter: PChar):Smallint; stdcall;
procedure VCGetStatusBarSize(var iError: smallint; var ipOrg: iPoint2D; var ipSize: iPoint2D); stdcall;
function VCGetToolbar(i: smallint):Smallint; stdcall;
function VCGetTopTool:Smallint; stdcall;
function VCGetUseHPGL2(var iError: smallint):Boolean; stdcall;
procedure VCHatchSettingsRibalog; stdcall;
procedure VCInitDialogs; stdcall;
procedure VCInitPrintMode(var iError: smallint; iPrintMode: smallint); stdcall;
procedure VCLayerMgr(var iError: smallint); stdcall;
procedure VCLayerGroupsDlg(var iError: smallint); stdcall;
procedure VCLoadAlias(szFile: PChar; var iError: smallint); stdcall;
procedure VCLoadCmdExt(szFile: PChar; var iError: smallint); stdcall;
procedure VCLoadMainSpeedbar(szFile: PChar; var iError: smallint); stdcall;
procedure VCLoadPlotterDriver(var iError: smallint; szName: PChar); stdcall;
procedure VCLoadPlotterLanguage(var iError: smallint; szName: PChar); stdcall;
procedure VCLoadPlotterPenMap(var iError: smallint; szName: PChar); stdcall;
procedure VCLoadToolPalette(szFile: PChar; var iError: smallint); stdcall;
procedure VCMeasureAngleRibalog; stdcall;
procedure VCMeasureAreaRibalog; stdcall;
procedure VCMeasureDistRibalog; stdcall;
procedure VCModalDlg(var iError: smallint; cmd_id: Longint); stdcall;
procedure VCNoDrawingSpeedbar(var iError: smallint); stdcall;
procedure VCObjectInfo(var iError: smallint); stdcall;
procedure VCOffsetRibalog; stdcall;
procedure VCOrthoAngleRibalog; stdcall;
procedure VCPlot(var iError: smallint); stdcall;
procedure VCPlotDlg(var iError: smallint); stdcall;
procedure VCPrint(var iError: smallint); stdcall;
procedure VCPrintDlg(var iError: smallint); stdcall;
procedure VCPropertiesRibalog; stdcall;
procedure VCRFBirdsEye(var iError: smallint); stdcall;
procedure VCRFLayerMgr(var iError: smallint); stdcall;
function VCRIsButtonDown(var iError: smallint; szNative: PChar; id: smallint):Boolean; stdcall;
procedure VCRemovePlotterPageSize(var iError: smallint; iIndex: smallint); stdcall;
procedure VCResetCmdExt(var iError: smallint); stdcall;
procedure VCResetPrintMargins(var iError: smallint); stdcall;
procedure VCSavePlotterDriver(var iError: smallint; szName: PChar); stdcall;
procedure VCSavePlotterLanguage(var iError: smallint; szName: PChar); stdcall;
procedure VCSavePlotterPenMap(var iError: smallint; szName: PChar); stdcall;
procedure VCScriptAssignRibalog; stdcall;
procedure VCSetDefaultPrinter(var iError: smallint; szDefaultPrinter: PChar); stdcall;
procedure VCSetDialogFrameHwnd(hWndFrame: smallint); stdcall;
procedure VCSetDialogToolFrameHwnd(hWndFrame: smallint); stdcall;
procedure VCSetEmbedded(tfEmbedded: wordbool); stdcall;
procedure VCSetPlotSettings(var iError: smallint; var pSettings: PlotStruct); stdcall;
procedure VCSetPlotterCurrentLanguageIndex(var iError: smallint; iIndex: smallint); stdcall;
procedure VCSetPlotterCurrentLanguageName(var iError: smallint; szLanguageName: PChar); stdcall;
procedure VCSetPlotterCurrentPageSize(var iError: smallint; iIndex: smallint); stdcall;
procedure VCSetPlotterCurrentPenMapIndex(var iError: smallint; iIndex: smallint); stdcall;
procedure VCSetPlotterCurrentPenMapName(var iError: smallint; szPenMapName: PChar); stdcall;
procedure VCSetPlotterDeInitString(var iError: smallint; sz: PChar); stdcall;
procedure VCSetPlotterDelimiter(var iError: smallint; sz: PChar); stdcall;
procedure VCSetPlotterInitString(var iError: smallint; sz: PChar); stdcall;
procedure VCSetPlotterPenChangeString(var iError: smallint; sz: PChar); stdcall;
procedure VCSetPlotterPenDownString(var iError: smallint; sz: PChar); stdcall;
procedure VCSetPlotterPenDrawString(var iError: smallint; sz: PChar); stdcall;
procedure VCSetPlotterPenMapping(var iError: smallint; iColor: smallint; iPen: smallint; dWidth: Double; iSpeed: smallint); stdcall;
procedure VCSetPlotterPenMoveString(var iError: smallint; sz: PChar); stdcall;
procedure VCSetPlotterPenSpeedString(var iError: smallint; sz: PChar); stdcall;
procedure VCSetPlotterPenUpString(var iError: smallint; sz: PChar); stdcall;
procedure VCSetPrintSettings(var iError: smallint; var pSettings: PrintStruct); stdcall;
procedure VCSetRefFrameNameDlg(var iError: smallint); stdcall;
procedure VCSetSpecificPrinter(var iError: smallint; szSpecificPrinter: PChar); stdcall;
procedure VCSetUseHPGL2(var iError: smallint; tf: wordbool); stdcall;
procedure VCSymCreateRibalog; stdcall;
procedure VCSymPlaceRibalog; stdcall;
procedure VCSymbolMgr(var iError: smallint); stdcall;
procedure VCTerminateDialogs; stdcall;
procedure VCTextLineRibalog; stdcall;
procedure VCTextSettingsRibalog; stdcall;
procedure VCUpdateBirdseyeView(var iError: smallint; tfRefresh: wordbool); stdcall;
procedure VCUpdateDialog(var iError: smallint); stdcall;

implementation

var
    hInst : THandle;

function VCLoadVCDLG32 : boolean;
begin
  hInst := LoadLibrary('VCDLG32.DLL');
  result := hInst >= 32;
end;

procedure VCFreeVCDLG32;
begin
  FreeLibrary(hInst);
end;

type TVCAddPlotter = procedure (var iError: smallint; szPlotterName: PChar); stdcall;

procedure VCAddPlotter (var iError: smallint; szPlotterName: PChar);
var aproc : TVCAddPlotter;
begin
  @aproc :=  GetProcAddress(hInst, 'VCAddPlotter');
  if @aproc <> nil then
      aproc(iError, szPlotterName);
end;

type TVCAddPlotterLanguageName = procedure (var iError: smallint; szLanguageName: PChar); stdcall;

procedure VCAddPlotterLanguageName (var iError: smallint; szLanguageName: PChar);
var aproc : TVCAddPlotterLanguageName;
begin
  @aproc :=  GetProcAddress(hInst, 'VCAddPlotterLanguageName');
  if @aproc <> nil then
      aproc(iError, szLanguageName);
end;

type TVCAddPlotterPageSize = procedure (var iError: smallint; var pPageSize: Point2D); stdcall;

procedure VCAddPlotterPageSize (var iError: smallint; var pPageSize: Point2D);
var aproc : TVCAddPlotterPageSize;
begin
  @aproc :=  GetProcAddress(hInst, 'VCAddPlotterPageSize');
  if @aproc <> nil then
      aproc(iError, pPageSize);
end;

type TVCAddPlotterPenMapName = procedure (var iError: smallint; szPenMapName: PChar); stdcall;

procedure VCAddPlotterPenMapName (var iError: smallint; szPenMapName: PChar);
var aproc : TVCAddPlotterPenMapName;
begin
  @aproc :=  GetProcAddress(hInst, 'VCAddPlotterPenMapName');
  if @aproc <> nil then
      aproc(iError, szPenMapName);
end;

type TVCApplyPlotterLanguageDefaults = procedure (var iError: smallint); stdcall;

procedure VCApplyPlotterLanguageDefaults (var iError: smallint);
var aproc : TVCApplyPlotterLanguageDefaults;
begin
  @aproc :=  GetProcAddress(hInst, 'VCApplyPlotterLanguageDefaults');
  if @aproc <> nil then
      aproc(iError);
end;

type TVCApplyPlotterPenMapDefaults = procedure (var iError: smallint); stdcall;

procedure VCApplyPlotterPenMapDefaults (var iError: smallint);
var aproc : TVCApplyPlotterPenMapDefaults;
begin
  @aproc :=  GetProcAddress(hInst, 'VCApplyPlotterPenMapDefaults');
  if @aproc <> nil then
      aproc(iError);
end;

type TVCBirdsEye = procedure (var iError: smallint; iDisplayMode: smallint); stdcall;

procedure VCBirdsEye (var iError: smallint; iDisplayMode: smallint);
var aproc : TVCBirdsEye;
begin
  @aproc :=  GetProcAddress(hInst, 'VCBirdsEye');
  if @aproc <> nil then
      aproc(iError, iDisplayMode);
end;

type TVCChangeRefFrameNameDlg = procedure (var iError: smallint); stdcall;

procedure VCChangeRefFrameNameDlg (var iError: smallint);
var aproc : TVCChangeRefFrameNameDlg;
begin
  @aproc :=  GetProcAddress(hInst, 'VCChangeRefFrameNameDlg');
  if @aproc <> nil then
      aproc(iError);
end;

type TVCChangeRibalog = procedure ; stdcall;

procedure VCChangeRibalog ;
var aproc : TVCChangeRibalog;
begin
  @aproc :=  GetProcAddress(hInst, 'VCChangeRibalog');
  if @aproc <> nil then
      aproc;
end;

type TVCCloseRibalog = procedure (var iError: smallint); stdcall;

procedure VCCloseRibalog (var iError: smallint);
var aproc : TVCCloseRibalog;
begin
  @aproc :=  GetProcAddress(hInst, 'VCCloseRibalog');
  if @aproc <> nil then
      aproc(iError);
end;

type TVCDBLineSettingsRibalog = procedure ; stdcall;

procedure VCDBLineSettingsRibalog ;
var aproc : TVCDBLineSettingsRibalog;
begin
  @aproc :=  GetProcAddress(hInst, 'VCDBLineSettingsRibalog');
  if @aproc <> nil then
      aproc;
end;

type TVCDeInitPrintMode = procedure (var iError: smallint); stdcall;

procedure VCDeInitPrintMode (var iError: smallint);
var aproc : TVCDeInitPrintMode;
begin
  @aproc :=  GetProcAddress(hInst, 'VCDeInitPrintMode');
  if @aproc <> nil then
      aproc(iError);
end;

type TVCDimArrowRibalog = procedure ; stdcall;

procedure VCDimArrowRibalog ;
var aproc : TVCDimArrowRibalog;
begin
  @aproc :=  GetProcAddress(hInst, 'VCDimArrowRibalog');
  if @aproc <> nil then
      aproc;
end;

type TVCDimDisplayRibalog = procedure ; stdcall;

procedure VCDimDisplayRibalog ;
var aproc : TVCDimDisplayRibalog;
begin
  @aproc :=  GetProcAddress(hInst, 'VCDimDisplayRibalog');
  if @aproc <> nil then
      aproc;
end;

type TVCDimExtRibalog = procedure ; stdcall;

procedure VCDimExtRibalog ;
var aproc : TVCDimExtRibalog;
begin
  @aproc :=  GetProcAddress(hInst, 'VCDimExtRibalog');
  if @aproc <> nil then
      aproc;
end;

type TVCDimLeaderRibalog = procedure ; stdcall;

procedure VCDimLeaderRibalog ;
var aproc : TVCDimLeaderRibalog;
begin
  @aproc :=  GetProcAddress(hInst, 'VCDimLeaderRibalog');
  if @aproc <> nil then
      aproc;
end;

type TVCDimLineRibalog = procedure ; stdcall;

procedure VCDimLineRibalog ;
var aproc : TVCDimLineRibalog;
begin
  @aproc :=  GetProcAddress(hInst, 'VCDimLineRibalog');
  if @aproc <> nil then
      aproc;
end;

type TVCDimStringsRibalog = procedure ; stdcall;

procedure VCDimStringsRibalog ;
var aproc : TVCDimStringsRibalog;
begin
  @aproc :=  GetProcAddress(hInst, 'VCDimStringsRibalog');
  if @aproc <> nil then
      aproc;
end;

type TVCDimTextRibalog = procedure ; stdcall;

procedure VCDimTextRibalog ;
var aproc : TVCDimTextRibalog;
begin
  @aproc :=  GetProcAddress(hInst, 'VCDimTextRibalog');
  if @aproc <> nil then
      aproc;
end;

type TVCDimToleranceRibalog = procedure ; stdcall;

procedure VCDimToleranceRibalog ;
var aproc : TVCDimToleranceRibalog;
begin
  @aproc :=  GetProcAddress(hInst, 'VCDimToleranceRibalog');
  if @aproc <> nil then
      aproc;
end;

type TVCFilletRadiusRibalog = procedure ; stdcall;

procedure VCFilletRadiusRibalog ;
var aproc : TVCFilletRadiusRibalog;
begin
  @aproc :=  GetProcAddress(hInst, 'VCFilletRadiusRibalog');
  if @aproc <> nil then
      aproc;
end;

type TVCFilterRibalog = procedure ; stdcall;

procedure VCFilterRibalog ;
var aproc : TVCFilterRibalog;
begin
  @aproc :=  GetProcAddress(hInst, 'VCFilterRibalog');
  if @aproc <> nil then
      aproc;
end;

type TVCGetCurrentPrinter = function (var iError: smallint; szPrinter: PChar):Smallint; stdcall;

function VCGetCurrentPrinter (var iError: smallint; szPrinter: PChar):Smallint;
var aproc : TVCGetCurrentPrinter;
begin
    result := Smallint(0);
  @aproc :=  GetProcAddress(hInst, 'VCGetCurrentPrinter');
  if @aproc <> nil then
    result :=   aproc(iError, szPrinter);
end;

type TVCGetDefaultPrinter = function (var iError: smallint; szDefaultPrinter: PChar):Smallint; stdcall;

function VCGetDefaultPrinter (var iError: smallint; szDefaultPrinter: PChar):Smallint;
var aproc : TVCGetDefaultPrinter;
begin
    result := Smallint(0);
  @aproc :=  GetProcAddress(hInst, 'VCGetDefaultPrinter');
  if @aproc <> nil then
    result :=   aproc(iError, szDefaultPrinter);
end;


type TVCGetDialogFromId = function (var id: smallint):Longint; stdcall;

function VCGetDialogFromId (var id: smallint):Longint;stdcall;
var aproc : TVCGetDialogFromId;
begin
    result := Smallint(0);
  @aproc :=  GetProcAddress(hInst, 'VCGetDialogFromId');
  if @aproc <> nil then
    result :=   aproc(id);
end;

type TVCGetPlotSettings = procedure (var iError: smallint; var pSettings: PlotStruct); stdcall;

procedure VCGetPlotSettings (var iError: smallint; var pSettings: PlotStruct);
var aproc : TVCGetPlotSettings;
begin
  @aproc :=  GetProcAddress(hInst, 'VCGetPlotSettings');
  if @aproc <> nil then
      aproc(iError, pSettings);
end;

type TVCGetPlotterCount = function (var iError: smallint):Smallint; stdcall;

function VCGetPlotterCount (var iError: smallint):Smallint;
var aproc : TVCGetPlotterCount;
begin
    result := Smallint(0);
  @aproc :=  GetProcAddress(hInst, 'VCGetPlotterCount');
  if @aproc <> nil then
    result :=   aproc(iError);
end;

type TVCGetPlotterCurrentLanguageName = function (var iError: smallint; szLanguageName: PChar):Smallint; stdcall;

function VCGetPlotterCurrentLanguageName (var iError: smallint; szLanguageName: PChar):Smallint;
var aproc : TVCGetPlotterCurrentLanguageName;
begin
    result := Smallint(0);
  @aproc :=  GetProcAddress(hInst, 'VCGetPlotterCurrentLanguageName');
  if @aproc <> nil then
    result :=   aproc(iError, szLanguageName);
end;

type TVCGetPlotterCurrentPageSize = procedure (var iError: smallint; var iIndex: smallint; var pPaperSize: Point2D); stdcall;

procedure VCGetPlotterCurrentPageSize (var iError: smallint; var iIndex: smallint; var pPaperSize: Point2D);
var aproc : TVCGetPlotterCurrentPageSize;
begin
  @aproc :=  GetProcAddress(hInst, 'VCGetPlotterCurrentPageSize');
  if @aproc <> nil then
      aproc(iError, iIndex, pPaperSize);
end;

type TVCGetPlotterCurrentPenMapName = function (var iError: smallint; szPenMapName: PChar):Smallint; stdcall;

function VCGetPlotterCurrentPenMapName (var iError: smallint; szPenMapName: PChar):Smallint;
var aproc : TVCGetPlotterCurrentPenMapName;
begin
    result := Smallint(0);
  @aproc :=  GetProcAddress(hInst, 'VCGetPlotterCurrentPenMapName');
  if @aproc <> nil then
    result :=   aproc(iError, szPenMapName);
end;

type TVCGetPlotterDeInitString = function (var iError: smallint; sz: PChar):Smallint; stdcall;

function VCGetPlotterDeInitString (var iError: smallint; sz: PChar):Smallint;
var aproc : TVCGetPlotterDeInitString;
begin
    result := Smallint(0);
  @aproc :=  GetProcAddress(hInst, 'VCGetPlotterDeInitString');
  if @aproc <> nil then
    result :=   aproc(iError, sz);
end;

type TVCGetPlotterDelimiter = function (var iError: smallint; sz: PChar):Smallint; stdcall;

function VCGetPlotterDelimiter (var iError: smallint; sz: PChar):Smallint;
var aproc : TVCGetPlotterDelimiter;
begin
    result := Smallint(0);
  @aproc :=  GetProcAddress(hInst, 'VCGetPlotterDelimiter');
  if @aproc <> nil then
    result :=   aproc(iError, sz);
end;

type TVCGetPlotterInitString = function (var iError: smallint; sz: PChar):Smallint; stdcall;

function VCGetPlotterInitString (var iError: smallint; sz: PChar):Smallint;
var aproc : TVCGetPlotterInitString;
begin
    result := Smallint(0);
  @aproc :=  GetProcAddress(hInst, 'VCGetPlotterInitString');
  if @aproc <> nil then
    result :=   aproc(iError, sz);
end;

type TVCGetPlotterLanguageCount = function (var iError: smallint):Smallint; stdcall;

function VCGetPlotterLanguageCount (var iError: smallint):Smallint;
var aproc : TVCGetPlotterLanguageCount;
begin
    result := Smallint(0);
  @aproc :=  GetProcAddress(hInst, 'VCGetPlotterLanguageCount');
  if @aproc <> nil then
    result :=   aproc(iError);
end;

type TVCGetPlotterLanguageName = function (var iError: smallint; iIndex: smallint; szLanguageName: PChar):Smallint; stdcall;

function VCGetPlotterLanguageName (var iError: smallint; iIndex: smallint; szLanguageName: PChar):Smallint;
var aproc : TVCGetPlotterLanguageName;
begin
    result := Smallint(0);
  @aproc :=  GetProcAddress(hInst, 'VCGetPlotterLanguageName');
  if @aproc <> nil then
    result :=   aproc(iError, iIndex, szLanguageName);
end;

type TVCGetPlotterPageSize = procedure (var iError: smallint; iIndex: smallint; var pPaperSize: Point2D); stdcall;

procedure VCGetPlotterPageSize (var iError: smallint; iIndex: smallint; var pPaperSize: Point2D);
var aproc : TVCGetPlotterPageSize;
begin
  @aproc :=  GetProcAddress(hInst, 'VCGetPlotterPageSize');
  if @aproc <> nil then
      aproc(iError, iIndex, pPaperSize);
end;

type TVCGetPlotterPageSizeCount = function (var iError: smallint):Smallint; stdcall;

function VCGetPlotterPageSizeCount (var iError: smallint):Smallint;
var aproc : TVCGetPlotterPageSizeCount;
begin
    result := Smallint(0);
  @aproc :=  GetProcAddress(hInst, 'VCGetPlotterPageSizeCount');
  if @aproc <> nil then
    result :=   aproc(iError);
end;

type TVCGetPlotterPenChangeString = function (var iError: smallint; sz: PChar):Smallint; stdcall;

function VCGetPlotterPenChangeString (var iError: smallint; sz: PChar):Smallint;
var aproc : TVCGetPlotterPenChangeString;
begin
    result := Smallint(0);
  @aproc :=  GetProcAddress(hInst, 'VCGetPlotterPenChangeString');
  if @aproc <> nil then
    result :=   aproc(iError, sz);
end;

type TVCGetPlotterPenDownString = function (var iError: smallint; sz: PChar):Smallint; stdcall;

function VCGetPlotterPenDownString (var iError: smallint; sz: PChar):Smallint;
var aproc : TVCGetPlotterPenDownString;
begin
    result := Smallint(0);
  @aproc :=  GetProcAddress(hInst, 'VCGetPlotterPenDownString');
  if @aproc <> nil then
    result :=   aproc(iError, sz);
end;

type TVCGetPlotterPenDrawString = function (var iError: smallint; sz: PChar):Smallint; stdcall;

function VCGetPlotterPenDrawString (var iError: smallint; sz: PChar):Smallint;
var aproc : TVCGetPlotterPenDrawString;
begin
    result := Smallint(0);
  @aproc :=  GetProcAddress(hInst, 'VCGetPlotterPenDrawString');
  if @aproc <> nil then
    result :=   aproc(iError, sz);
end;

type TVCGetPlotterPenMapCount = function (var iError: smallint):Smallint; stdcall;

function VCGetPlotterPenMapCount (var iError: smallint):Smallint;
var aproc : TVCGetPlotterPenMapCount;
begin
    result := Smallint(0);
  @aproc :=  GetProcAddress(hInst, 'VCGetPlotterPenMapCount');
  if @aproc <> nil then
    result :=   aproc(iError);
end;

type TVCGetPlotterPenMapName = function (var iError: smallint; iIndex: smallint; szPenMapName: PChar):Smallint; stdcall;

function VCGetPlotterPenMapName (var iError: smallint; iIndex: smallint; szPenMapName: PChar):Smallint;
var aproc : TVCGetPlotterPenMapName;
begin
    result := Smallint(0);
  @aproc :=  GetProcAddress(hInst, 'VCGetPlotterPenMapName');
  if @aproc <> nil then
    result :=   aproc(iError, iIndex, szPenMapName);
end;

type TVCGetPlotterPenMapping = procedure (var iError: smallint; iColor: smallint; var iPen: smallint; var dWidth: Double; var iSpeed: smallint); stdcall;

procedure VCGetPlotterPenMapping (var iError: smallint; iColor: smallint; var iPen: smallint; var dWidth: Double; var iSpeed: smallint);
var aproc : TVCGetPlotterPenMapping;
begin
  @aproc :=  GetProcAddress(hInst, 'VCGetPlotterPenMapping');
  if @aproc <> nil then
      aproc(iError, iColor, iPen, dWidth, iSpeed);
end;

type TVCGetPlotterPenMoveString = function (var iError: smallint; sz: PChar):Smallint; stdcall;

function VCGetPlotterPenMoveString (var iError: smallint; sz: PChar):Smallint;
var aproc : TVCGetPlotterPenMoveString;
begin
    result := Smallint(0);
  @aproc :=  GetProcAddress(hInst, 'VCGetPlotterPenMoveString');
  if @aproc <> nil then
    result :=   aproc(iError, sz);
end;

type TVCGetPlotterPenSpeedString = function (var iError: smallint; sz: PChar):Smallint; stdcall;

function VCGetPlotterPenSpeedString (var iError: smallint; sz: PChar):Smallint;
var aproc : TVCGetPlotterPenSpeedString;
begin
    result := Smallint(0);
  @aproc :=  GetProcAddress(hInst, 'VCGetPlotterPenSpeedString');
  if @aproc <> nil then
    result :=   aproc(iError, sz);
end;

type TVCGetPlotterPenUpString = function (var iError: smallint; sz: PChar):Smallint; stdcall;

function VCGetPlotterPenUpString (var iError: smallint; sz: PChar):Smallint;
var aproc : TVCGetPlotterPenUpString;
begin
    result := Smallint(0);
  @aproc :=  GetProcAddress(hInst, 'VCGetPlotterPenUpString');
  if @aproc <> nil then
    result :=   aproc(iError, sz);
end;

type TVCGetPrintSettings = procedure (var iError: smallint; var pSettings: PrintStruct); stdcall;

procedure VCGetPrintSettings (var iError: smallint; var pSettings: PrintStruct);
var aproc : TVCGetPrintSettings;
begin
  @aproc :=  GetProcAddress(hInst, 'VCGetPrintSettings');
  if @aproc <> nil then
      aproc(iError, pSettings);
end;

type TVCGetPrinterName = function (var iError: smallint; iIndex: smallint; szPrinter: PChar):Smallint; stdcall;

function VCGetPrinterName (var iError: smallint; iIndex: smallint; szPrinter: PChar):Smallint;
var aproc : TVCGetPrinterName;
begin
    result := Smallint(0);
  @aproc :=  GetProcAddress(hInst, 'VCGetPrinterName');
  if @aproc <> nil then
    result :=   aproc(iError, iIndex, szPrinter);
end;

type TVCGetPrinterNameCount = function (var iError: smallint):Smallint; stdcall;

function VCGetPrinterNameCount (var iError: smallint):Smallint;
var aproc : TVCGetPrinterNameCount;
begin
    result := Smallint(0);
  @aproc :=  GetProcAddress(hInst, 'VCGetPrinterNameCount');
  if @aproc <> nil then
    result :=   aproc(iError);
end;

type TVCGetRibalogSize = procedure (var iError: smallint; var ipOrg: iPoint2D; var ipSize: iPoint2D); stdcall;

procedure VCGetRibalogSize (var iError: smallint; var ipOrg: iPoint2D; var ipSize: iPoint2D);
var aproc : TVCGetRibalogSize;
begin
  @aproc :=  GetProcAddress(hInst, 'VCGetRibalogSize');
  if @aproc <> nil then
      aproc(iError, ipOrg, ipSize);
end;

type TVCGetSpecificPrinter = function (var iError: smallint; szSpecificPrinter: PChar):Smallint; stdcall;

function VCGetSpecificPrinter (var iError: smallint; szSpecificPrinter: PChar):Smallint;
var aproc : TVCGetSpecificPrinter;
begin
    result := Smallint(0);
  @aproc :=  GetProcAddress(hInst, 'VCGetSpecificPrinter');
  if @aproc <> nil then
    result :=   aproc(iError, szSpecificPrinter);
end;

type TVCGetStatusBarSize = procedure (var iError: smallint; var ipOrg: iPoint2D; var ipSize: iPoint2D); stdcall;

procedure VCGetStatusBarSize (var iError: smallint; var ipOrg: iPoint2D; var ipSize: iPoint2D);
var aproc : TVCGetStatusBarSize;
begin
  @aproc :=  GetProcAddress(hInst, 'VCGetStatusBarSize');
  if @aproc <> nil then
      aproc(iError, ipOrg, ipSize);
end;

type TVCGetToolbar = function (i: smallint):Smallint; stdcall;

function VCGetToolbar (i: smallint):Smallint;
var aproc : TVCGetToolbar;
begin
    result := Smallint(0);
  @aproc :=  GetProcAddress(hInst, 'VCGetToolbar');
  if @aproc <> nil then
    result :=   aproc(i);
end;

type TVCGetTopTool = function :Smallint; stdcall;

function VCGetTopTool :Smallint;
var aproc : TVCGetTopTool;
begin
    result := Smallint(0);
  @aproc :=  GetProcAddress(hInst, 'VCGetTopTool');
  if @aproc <> nil then
    result :=   aproc;
end;

type TVCGetUseHPGL2 = function (var iError: smallint):Boolean; stdcall;

function VCGetUseHPGL2 (var iError: smallint):Boolean;
var aproc : TVCGetUseHPGL2;
begin
    result := Boolean(0);
  @aproc :=  GetProcAddress(hInst, 'VCGetUseHPGL2');
  if @aproc <> nil then
    result :=   aproc(iError);
end;

type TVCHatchSettingsRibalog = procedure ; stdcall;

procedure VCHatchSettingsRibalog ;
var aproc : TVCHatchSettingsRibalog;
begin
  @aproc :=  GetProcAddress(hInst, 'VCHatchSettingsRibalog');
  if @aproc <> nil then
      aproc;
end;

type TVCInitDialogs = procedure ; stdcall;

procedure VCInitDialogs ;
var aproc : TVCInitDialogs;
begin
  @aproc :=  GetProcAddress(hInst, 'VCInitDialogs');
  if @aproc <> nil then
      aproc;
end;

type TVCInitPrintMode = procedure (var iError: smallint; iPrintMode: smallint); stdcall;

procedure VCInitPrintMode (var iError: smallint; iPrintMode: smallint);
var aproc : TVCInitPrintMode;
begin
  @aproc :=  GetProcAddress(hInst, 'VCInitPrintMode');
  if @aproc <> nil then
      aproc(iError, iPrintMode);
end;

type TVCLayerMgr = procedure (var iError: smallint); stdcall;

procedure VCLayerMgr (var iError: smallint);
var aproc : TVCLayerMgr;
begin
  @aproc :=  GetProcAddress(hInst, 'VCLayerMgr');
  if @aproc <> nil then
      aproc(iError);
end;

type TVCLayerGroupsDlg = procedure (var iError: smallint); stdcall;

procedure VCLayerGroupsDlg (var iError: smallint);
var aproc : TVCLayerGroupsDlg;
begin
  @aproc :=  GetProcAddress(hInst, 'VCLayerGroupsDlg');
  if @aproc <> nil then
      aproc(iError);
end;

type TVCLoadAlias = procedure (szFile: PChar; var iError: smallint); stdcall;

procedure VCLoadAlias (szFile: PChar; var iError: smallint);
var aproc : TVCLoadAlias;
begin
  @aproc :=  GetProcAddress(hInst, 'VCLoadAlias');
  if @aproc <> nil then
      aproc(szFile, iError);
end;

type TVCLoadCmdExt = procedure (szFile: PChar; var iError: smallint); stdcall;

procedure VCLoadCmdExt (szFile: PChar; var iError: smallint);
var aproc : TVCLoadCmdExt;
begin
  @aproc :=  GetProcAddress(hInst, 'VCLoadCmdExt');
  if @aproc <> nil then
      aproc(szFile, iError);
end;

type TVCLoadMainSpeedbar = procedure (szFile: PChar; var iError: smallint); stdcall;

procedure VCLoadMainSpeedbar (szFile: PChar; var iError: smallint);
var aproc : TVCLoadMainSpeedbar;
begin
  @aproc :=  GetProcAddress(hInst, 'VCLoadMainSpeedbar');
  if @aproc <> nil then
      aproc(szFile, iError);
end;

type TVCLoadPlotterDriver = procedure (var iError: smallint; szName: PChar); stdcall;

procedure VCLoadPlotterDriver (var iError: smallint; szName: PChar);
var aproc : TVCLoadPlotterDriver;
begin
  @aproc :=  GetProcAddress(hInst, 'VCLoadPlotterDriver');
  if @aproc <> nil then
      aproc(iError, szName);
end;

type TVCLoadPlotterLanguage = procedure (var iError: smallint; szName: PChar); stdcall;

procedure VCLoadPlotterLanguage (var iError: smallint; szName: PChar);
var aproc : TVCLoadPlotterLanguage;
begin
  @aproc :=  GetProcAddress(hInst, 'VCLoadPlotterLanguage');
  if @aproc <> nil then
      aproc(iError, szName);
end;

type TVCLoadPlotterPenMap = procedure (var iError: smallint; szName: PChar); stdcall;

procedure VCLoadPlotterPenMap (var iError: smallint; szName: PChar);
var aproc : TVCLoadPlotterPenMap;
begin
  @aproc :=  GetProcAddress(hInst, 'VCLoadPlotterPenMap');
  if @aproc <> nil then
      aproc(iError, szName);
end;

type TVCLoadToolPalette = procedure (szFile: PChar; var iError: smallint); stdcall;

procedure VCLoadToolPalette (szFile: PChar; var iError: smallint);
var aproc : TVCLoadToolPalette;
begin
  @aproc :=  GetProcAddress(hInst, 'VCLoadToolPalette');
  if @aproc <> nil then
      aproc(szFile, iError);
end;

type TVCMeasureAngleRibalog = procedure ; stdcall;

procedure VCMeasureAngleRibalog ;
var aproc : TVCMeasureAngleRibalog;
begin
  @aproc :=  GetProcAddress(hInst, 'VCMeasureAngleRibalog');
  if @aproc <> nil then
      aproc;
end;

type TVCMeasureAreaRibalog = procedure ; stdcall;

procedure VCMeasureAreaRibalog ;
var aproc : TVCMeasureAreaRibalog;
begin
  @aproc :=  GetProcAddress(hInst, 'VCMeasureAreaRibalog');
  if @aproc <> nil then
      aproc;
end;

type TVCMeasureDistRibalog = procedure ; stdcall;

procedure VCMeasureDistRibalog ;
var aproc : TVCMeasureDistRibalog;
begin
  @aproc :=  GetProcAddress(hInst, 'VCMeasureDistRibalog');
  if @aproc <> nil then
      aproc;
end;

type TVCModalDlg = procedure (var iError: smallint; cmd_id: Longint); stdcall;

procedure VCModalDlg (var iError: smallint; cmd_id: Longint);
var aproc : TVCModalDlg;
begin
  @aproc :=  GetProcAddress(hInst, 'VCModalDlg');
  if @aproc <> nil then
      aproc(iError, cmd_id);
end;

type TVCNoDrawingSpeedbar = procedure (var iError: smallint); stdcall;

procedure VCNoDrawingSpeedbar (var iError: smallint);
var aproc : TVCNoDrawingSpeedbar;
begin
  @aproc :=  GetProcAddress(hInst, 'VCNoDrawingSpeedbar');
  if @aproc <> nil then
      aproc(iError);
end;

type TVCObjectInfo = procedure (var iError: smallint); stdcall;

procedure VCObjectInfo (var iError: smallint);
var aproc : TVCObjectInfo;
begin
  @aproc :=  GetProcAddress(hInst, 'VCObjectInfo');
  if @aproc <> nil then
      aproc(iError);
end;

type TVCOffsetRibalog = procedure ; stdcall;

procedure VCOffsetRibalog ;
var aproc : TVCOffsetRibalog;
begin
  @aproc :=  GetProcAddress(hInst, 'VCOffsetRibalog');
  if @aproc <> nil then
      aproc;
end;

type TVCOrthoAngleRibalog = procedure ; stdcall;

procedure VCOrthoAngleRibalog ;
var aproc : TVCOrthoAngleRibalog;
begin
  @aproc :=  GetProcAddress(hInst, 'VCOrthoAngleRibalog');
  if @aproc <> nil then
      aproc;
end;

type TVCPlot = procedure (var iError: smallint); stdcall;

procedure VCPlot (var iError: smallint);
var aproc : TVCPlot;
begin
  @aproc :=  GetProcAddress(hInst, 'VCPlot');
  if @aproc <> nil then
      aproc(iError);
end;

type TVCPlotDlg = procedure (var iError: smallint); stdcall;

procedure VCPlotDlg (var iError: smallint);
var aproc : TVCPlotDlg;
begin
  @aproc :=  GetProcAddress(hInst, 'VCPlotDlg');
  if @aproc <> nil then
      aproc(iError);
end;

type TVCPrint = procedure (var iError: smallint); stdcall;

procedure VCPrint (var iError: smallint);
var aproc : TVCPrint;
begin
  @aproc :=  GetProcAddress(hInst, 'VCPrint');
  if @aproc <> nil then
      aproc(iError);
end;

type TVCPrintDlg = procedure (var iError: smallint); stdcall;

procedure VCPrintDlg (var iError: smallint);
var aproc : TVCPrintDlg;
begin
  @aproc :=  GetProcAddress(hInst, 'VCPrintDlg');
  if @aproc <> nil then
      aproc(iError);
end;

type TVCPropertiesRibalog = procedure ; stdcall;

procedure VCPropertiesRibalog ;
var aproc : TVCPropertiesRibalog;
begin
  @aproc :=  GetProcAddress(hInst, 'VCPropertiesRibalog');
  if @aproc <> nil then
      aproc;
end;

type TVCRFBirdsEye = procedure (var iError: smallint); stdcall;

procedure VCRFBirdsEye (var iError: smallint);
var aproc : TVCRFBirdsEye;
begin
  @aproc :=  GetProcAddress(hInst, 'VCRFBirdsEye');
  if @aproc <> nil then
      aproc(iError);
end;

type TVCRFLayerMgr = procedure (var iError: smallint); stdcall;

procedure VCRFLayerMgr (var iError: smallint);
var aproc : TVCRFLayerMgr;
begin
  @aproc :=  GetProcAddress(hInst, 'VCRFLayerMgr');
  if @aproc <> nil then
      aproc(iError);
end;

type TVCRIsButtonDown = function (var iError: smallint; szNative: PChar; id: smallint):Boolean; stdcall;

function VCRIsButtonDown (var iError: smallint; szNative: PChar; id: smallint):Boolean;
var aproc : TVCRIsButtonDown;
begin
    result := Boolean(0);
  @aproc :=  GetProcAddress(hInst, 'VCRIsButtonDown');
  if @aproc <> nil then
    result :=   aproc(iError, szNative, id);
end;

type TVCRemovePlotterPageSize = procedure (var iError: smallint; iIndex: smallint); stdcall;

procedure VCRemovePlotterPageSize (var iError: smallint; iIndex: smallint);
var aproc : TVCRemovePlotterPageSize;
begin
  @aproc :=  GetProcAddress(hInst, 'VCRemovePlotterPageSize');
  if @aproc <> nil then
      aproc(iError, iIndex);
end;

type TVCResetCmdExt = procedure (var iError: smallint); stdcall;

procedure VCResetCmdExt (var iError: smallint);
var aproc : TVCResetCmdExt;
begin
  @aproc :=  GetProcAddress(hInst, 'VCResetCmdExt');
  if @aproc <> nil then
      aproc(iError);
end;

type TVCResetPrintMargins = procedure (var iError: smallint); stdcall;

procedure VCResetPrintMargins (var iError: smallint);
var aproc : TVCResetPrintMargins;
begin
  @aproc :=  GetProcAddress(hInst, 'VCResetPrintMargins');
  if @aproc <> nil then
      aproc(iError);
end;

type TVCSavePlotterDriver = procedure (var iError: smallint; szName: PChar); stdcall;

procedure VCSavePlotterDriver (var iError: smallint; szName: PChar);
var aproc : TVCSavePlotterDriver;
begin
  @aproc :=  GetProcAddress(hInst, 'VCSavePlotterDriver');
  if @aproc <> nil then
      aproc(iError, szName);
end;

type TVCSavePlotterLanguage = procedure (var iError: smallint; szName: PChar); stdcall;

procedure VCSavePlotterLanguage (var iError: smallint; szName: PChar);
var aproc : TVCSavePlotterLanguage;
begin
  @aproc :=  GetProcAddress(hInst, 'VCSavePlotterLanguage');
  if @aproc <> nil then
      aproc(iError, szName);
end;

type TVCSavePlotterPenMap = procedure (var iError: smallint; szName: PChar); stdcall;

procedure VCSavePlotterPenMap (var iError: smallint; szName: PChar);
var aproc : TVCSavePlotterPenMap;
begin
  @aproc :=  GetProcAddress(hInst, 'VCSavePlotterPenMap');
  if @aproc <> nil then
      aproc(iError, szName);
end;

type TVCScriptAssignRibalog = procedure ; stdcall;

procedure VCScriptAssignRibalog ;
var aproc : TVCScriptAssignRibalog;
begin
  @aproc :=  GetProcAddress(hInst, 'VCScriptAssignRibalog');
  if @aproc <> nil then
      aproc;
end;

type TVCSetDefaultPrinter = procedure (var iError: smallint; szDefaultPrinter: PChar); stdcall;

procedure VCSetDefaultPrinter (var iError: smallint; szDefaultPrinter: PChar);
var aproc : TVCSetDefaultPrinter;
begin
  @aproc :=  GetProcAddress(hInst, 'VCSetDefaultPrinter');
  if @aproc <> nil then
      aproc(iError, szDefaultPrinter);
end;

type TVCSetDialogFrameHwnd = procedure (hWndFrame: smallint); stdcall;

procedure VCSetDialogFrameHwnd (hWndFrame: smallint);
var aproc : TVCSetDialogFrameHwnd;
begin
  @aproc :=  GetProcAddress(hInst, 'VCSetDialogFrameHwnd');
  if @aproc <> nil then
      aproc(hWndFrame);
end;

type TVCSetDialogToolFrameHwnd = procedure (hWndFrame: smallint); stdcall;

procedure VCSetDialogToolFrameHwnd (hWndFrame: smallint);
var aproc : TVCSetDialogToolFrameHwnd;
begin
  @aproc :=  GetProcAddress(hInst, 'VCSetDialogToolFrameHwnd');
  if @aproc <> nil then
      aproc(hWndFrame);
end;

type TVCSetEmbedded = procedure (tfEmbedded: wordbool); stdcall;

procedure VCSetEmbedded (tfEmbedded: wordbool);
var aproc : TVCSetEmbedded;
begin
  @aproc :=  GetProcAddress(hInst, 'VCSetEmbedded');
  if @aproc <> nil then
      aproc(tfEmbedded);
end;

type TVCSetPlotSettings = procedure (var iError: smallint; var pSettings: PlotStruct); stdcall;

procedure VCSetPlotSettings (var iError: smallint; var pSettings: PlotStruct);
var aproc : TVCSetPlotSettings;
begin
  @aproc :=  GetProcAddress(hInst, 'VCSetPlotSettings');
  if @aproc <> nil then
      aproc(iError, pSettings);
end;

type TVCSetPlotterCurrentLanguageIndex = procedure (var iError: smallint; iIndex: smallint); stdcall;

procedure VCSetPlotterCurrentLanguageIndex (var iError: smallint; iIndex: smallint);
var aproc : TVCSetPlotterCurrentLanguageIndex;
begin
  @aproc :=  GetProcAddress(hInst, 'VCSetPlotterCurrentLanguageIndex');
  if @aproc <> nil then
      aproc(iError, iIndex);
end;

type TVCSetPlotterCurrentLanguageName = procedure (var iError: smallint; szLanguageName: PChar); stdcall;

procedure VCSetPlotterCurrentLanguageName (var iError: smallint; szLanguageName: PChar);
var aproc : TVCSetPlotterCurrentLanguageName;
begin
  @aproc :=  GetProcAddress(hInst, 'VCSetPlotterCurrentLanguageName');
  if @aproc <> nil then
      aproc(iError, szLanguageName);
end;

type TVCSetPlotterCurrentPageSize = procedure (var iError: smallint; iIndex: smallint); stdcall;

procedure VCSetPlotterCurrentPageSize (var iError: smallint; iIndex: smallint);
var aproc : TVCSetPlotterCurrentPageSize;
begin
  @aproc :=  GetProcAddress(hInst, 'VCSetPlotterCurrentPageSize');
  if @aproc <> nil then
      aproc(iError, iIndex);
end;

type TVCSetPlotterCurrentPenMapIndex = procedure (var iError: smallint; iIndex: smallint); stdcall;

procedure VCSetPlotterCurrentPenMapIndex (var iError: smallint; iIndex: smallint);
var aproc : TVCSetPlotterCurrentPenMapIndex;
begin
  @aproc :=  GetProcAddress(hInst, 'VCSetPlotterCurrentPenMapIndex');
  if @aproc <> nil then
      aproc(iError, iIndex);
end;

type TVCSetPlotterCurrentPenMapName = procedure (var iError: smallint; szPenMapName: PChar); stdcall;

procedure VCSetPlotterCurrentPenMapName (var iError: smallint; szPenMapName: PChar);
var aproc : TVCSetPlotterCurrentPenMapName;
begin
  @aproc :=  GetProcAddress(hInst, 'VCSetPlotterCurrentPenMapName');
  if @aproc <> nil then
      aproc(iError, szPenMapName);
end;

type TVCSetPlotterDeInitString = procedure (var iError: smallint; sz: PChar); stdcall;

procedure VCSetPlotterDeInitString (var iError: smallint; sz: PChar);
var aproc : TVCSetPlotterDeInitString;
begin
  @aproc :=  GetProcAddress(hInst, 'VCSetPlotterDeInitString');
  if @aproc <> nil then
      aproc(iError, sz);
end;

type TVCSetPlotterDelimiter = procedure (var iError: smallint; sz: PChar); stdcall;

procedure VCSetPlotterDelimiter (var iError: smallint; sz: PChar);
var aproc : TVCSetPlotterDelimiter;
begin
  @aproc :=  GetProcAddress(hInst, 'VCSetPlotterDelimiter');
  if @aproc <> nil then
      aproc(iError, sz);
end;

type TVCSetPlotterInitString = procedure (var iError: smallint; sz: PChar); stdcall;

procedure VCSetPlotterInitString (var iError: smallint; sz: PChar);
var aproc : TVCSetPlotterInitString;
begin
  @aproc :=  GetProcAddress(hInst, 'VCSetPlotterInitString');
  if @aproc <> nil then
      aproc(iError, sz);
end;

type TVCSetPlotterPenChangeString = procedure (var iError: smallint; sz: PChar); stdcall;

procedure VCSetPlotterPenChangeString (var iError: smallint; sz: PChar);
var aproc : TVCSetPlotterPenChangeString;
begin
  @aproc :=  GetProcAddress(hInst, 'VCSetPlotterPenChangeString');
  if @aproc <> nil then
      aproc(iError, sz);
end;

type TVCSetPlotterPenDownString = procedure (var iError: smallint; sz: PChar); stdcall;

procedure VCSetPlotterPenDownString (var iError: smallint; sz: PChar);
var aproc : TVCSetPlotterPenDownString;
begin
  @aproc :=  GetProcAddress(hInst, 'VCSetPlotterPenDownString');
  if @aproc <> nil then
      aproc(iError, sz);
end;

type TVCSetPlotterPenDrawString = procedure (var iError: smallint; sz: PChar); stdcall;

procedure VCSetPlotterPenDrawString (var iError: smallint; sz: PChar);
var aproc : TVCSetPlotterPenDrawString;
begin
  @aproc :=  GetProcAddress(hInst, 'VCSetPlotterPenDrawString');
  if @aproc <> nil then
      aproc(iError, sz);
end;

type TVCSetPlotterPenMapping = procedure (var iError: smallint; iColor: smallint; iPen: smallint; dWidth: Double; iSpeed: smallint); stdcall;

procedure VCSetPlotterPenMapping (var iError: smallint; iColor: smallint; iPen: smallint; dWidth: Double; iSpeed: smallint);
var aproc : TVCSetPlotterPenMapping;
begin
  @aproc :=  GetProcAddress(hInst, 'VCSetPlotterPenMapping');
  if @aproc <> nil then
      aproc(iError, iColor, iPen, dWidth, iSpeed);
end;

type TVCSetPlotterPenMoveString = procedure (var iError: smallint; sz: PChar); stdcall;

procedure VCSetPlotterPenMoveString (var iError: smallint; sz: PChar);
var aproc : TVCSetPlotterPenMoveString;
begin
  @aproc :=  GetProcAddress(hInst, 'VCSetPlotterPenMoveString');
  if @aproc <> nil then
      aproc(iError, sz);
end;

type TVCSetPlotterPenSpeedString = procedure (var iError: smallint; sz: PChar); stdcall;

procedure VCSetPlotterPenSpeedString (var iError: smallint; sz: PChar);
var aproc : TVCSetPlotterPenSpeedString;
begin
  @aproc :=  GetProcAddress(hInst, 'VCSetPlotterPenSpeedString');
  if @aproc <> nil then
      aproc(iError, sz);
end;

type TVCSetPlotterPenUpString = procedure (var iError: smallint; sz: PChar); stdcall;

procedure VCSetPlotterPenUpString (var iError: smallint; sz: PChar);
var aproc : TVCSetPlotterPenUpString;
begin
  @aproc :=  GetProcAddress(hInst, 'VCSetPlotterPenUpString');
  if @aproc <> nil then
      aproc(iError, sz);
end;

type TVCSetPrintSettings = procedure (var iError: smallint; var pSettings: PrintStruct); stdcall;

procedure VCSetPrintSettings (var iError: smallint; var pSettings: PrintStruct);
var aproc : TVCSetPrintSettings;
begin
  @aproc :=  GetProcAddress(hInst, 'VCSetPrintSettings');
  if @aproc <> nil then
      aproc(iError, pSettings);
end;

type TVCSetRefFrameNameDlg = procedure (var iError: smallint); stdcall;

procedure VCSetRefFrameNameDlg (var iError: smallint);
var aproc : TVCSetRefFrameNameDlg;
begin
  @aproc :=  GetProcAddress(hInst, 'VCSetRefFrameNameDlg');
  if @aproc <> nil then
      aproc(iError);
end;

type TVCSetSpecificPrinter = procedure (var iError: smallint; szSpecificPrinter: PChar); stdcall;

procedure VCSetSpecificPrinter (var iError: smallint; szSpecificPrinter: PChar);
var aproc : TVCSetSpecificPrinter;
begin
  @aproc :=  GetProcAddress(hInst, 'VCSetSpecificPrinter');
  if @aproc <> nil then
      aproc(iError, szSpecificPrinter);
end;

type TVCSetUseHPGL2 = procedure (var iError: smallint; tf: wordbool); stdcall;

procedure VCSetUseHPGL2 (var iError: smallint; tf: wordbool);
var aproc : TVCSetUseHPGL2;
begin
  @aproc :=  GetProcAddress(hInst, 'VCSetUseHPGL2');
  if @aproc <> nil then
      aproc(iError, tf);
end;

type TVCSymCreateRibalog = procedure ; stdcall;

procedure VCSymCreateRibalog ;
var aproc : TVCSymCreateRibalog;
begin
  @aproc :=  GetProcAddress(hInst, 'VCSymCreateRibalog');
  if @aproc <> nil then
      aproc;
end;

type TVCSymPlaceRibalog = procedure ; stdcall;

procedure VCSymPlaceRibalog ;
var aproc : TVCSymPlaceRibalog;
begin
  @aproc :=  GetProcAddress(hInst, 'VCSymPlaceRibalog');
  if @aproc <> nil then
      aproc;
end;

type TVCSymbolMgr = procedure (var iError: smallint); stdcall;

procedure VCSymbolMgr (var iError: smallint);
var aproc : TVCSymbolMgr;
begin
  @aproc :=  GetProcAddress(hInst, 'VCSymbolMgr');
  if @aproc <> nil then
      aproc(iError);
end;

type TVCTerminateDialogs = procedure ; stdcall;

procedure VCTerminateDialogs ;
var aproc : TVCTerminateDialogs;
begin
  @aproc :=  GetProcAddress(hInst, 'VCTerminateDialogs');
  if @aproc <> nil then
      aproc;
end;

type TVCTextLineRibalog = procedure ; stdcall;

procedure VCTextLineRibalog ;
var aproc : TVCTextLineRibalog;
begin
  @aproc :=  GetProcAddress(hInst, 'VCTextLineRibalog');
  if @aproc <> nil then
      aproc;
end;

type TVCTextSettingsRibalog = procedure ; stdcall;

procedure VCTextSettingsRibalog ;
var aproc : TVCTextSettingsRibalog;
begin
  @aproc :=  GetProcAddress(hInst, 'VCTextSettingsRibalog');
  if @aproc <> nil then
      aproc;
end;

type TVCUpdateBirdseyeView = procedure (var iError: smallint; tfRefresh: wordbool); stdcall;

procedure VCUpdateBirdseyeView (var iError: smallint; tfRefresh: wordbool);
var aproc : TVCUpdateBirdseyeView;
begin
  @aproc :=  GetProcAddress(hInst, 'VCUpdateBirdseyeView');
  if @aproc <> nil then
      aproc(iError, tfRefresh);
end;

type TVCUpdateDialog = procedure (var iError: smallint); stdcall;

procedure VCUpdateDialog (var iError: smallint);
var aproc : TVCUpdateDialog;
begin
  @aproc :=  GetProcAddress(hInst, 'VCUpdateDialog');
  if @aproc <> nil then
      aproc(iError);
end;


end.